local stages = Def.ActorFrame {};
local pm = GAMESTATE:GetPlayMode();
local stage = pm == 'PlayMode_Regular' and GAMESTATE:GetCurrentStage() or
	'Stage_' .. string.sub(pm, 10);

stages[#stages+1] = LoadFont("Common Normal") .. {
	InitCommand=cmd(NoStroke;shadowlength,1;diffusebottomedge,cBlue);
	OnCommand=cmd(diffusealpha,0;linear,1;diffusealpha,1;sleep,1;playcommand,"Off");
	OffCommand=cmd(accelerate,0.5;zoomy,0);
	SetCommand=function(self, params)
		self:visible( params.StageToShow == stage );
		self:settext( FormatNumberAndSuffix(params.StageNumber+1) .. " STAGE" );
	end;
};

return stages;
